/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.JDialog;

public abstract class VWModelessDialog
extends JDialog {
    public static final int POSITION_CENTERED = 0;
    public static final int POSITION_TOP_LEFT = 1;
    public static final int POSITION_TOP_RIGHT = 2;
    public static final int POSITION_BOTTOM_LEFT = 3;
    public static final int POSITION_BOTTOM_RIGHT = 4;
    protected static final int POSITION_BUFFER = 20;
    protected Container m_parentContainer = null;
    protected VWSessionInfo m_sessionInfo = null;

    public VWModelessDialog(Frame parentFrame, VWSessionInfo sessionInfo) {
        super(parentFrame);
        this.m_parentContainer = parentFrame;
        this.m_sessionInfo = sessionInfo;
    }

    public VWModelessDialog(Dialog parentDialog, VWSessionInfo sessionInfo) {
        super(parentDialog);
        this.m_parentContainer = parentDialog;
        this.m_sessionInfo = sessionInfo;
    }

    public void removeReferences() {
        this.m_parentContainer = null;
        this.m_sessionInfo = null;
    }

    protected void updateComponentOrientation() {
        try {
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void saveWindowPosition(String positionKey, String sizeKey) {
        try {
            VWUserInfo vwUserInfo = null;
            if (this.m_sessionInfo.getSession() != null) {
                vwUserInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            }
            if (vwUserInfo != null) {
                if (positionKey != null && positionKey.length() > 0) {
                    Point location = this.getLocation();
                    String sPosition = VWStringUtils.dimensionToString(location.x, location.y);
                    vwUserInfo.setFieldValue(positionKey, sPosition);
                }
                if (sizeKey != null && sizeKey.length() > 0) {
                    Dimension size = this.getSize();
                    String sSize = VWStringUtils.dimensionToString(size.width, size.height);
                    vwUserInfo.setFieldValue(sizeKey, sSize);
                }
                vwUserInfo.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean updateWindowPosition(String positionKey, String sizeKey) {
        VWUserInfo vwUserInfo = null;
        boolean bSuccessful = true;
        try {
            if (this.m_sessionInfo.getSession() != null) {
                vwUserInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            }
        }
        catch (Exception ex) {
            return false;
        }
        if (vwUserInfo == null) {
            return false;
        }
        if (sizeKey != null && sizeKey.length() > 0) {
            try {
                Dimension size = VWStringUtils.stringToDimension((String)vwUserInfo.getFieldValue(sizeKey));
                if (size != null) {
                    if (size.width <= 0 || size.height <= 0) {
                        return false;
                    }
                    this.setSize(size);
                }
            }
            catch (Exception ex) {
                bSuccessful = false;
            }
        }
        if (positionKey != null && positionKey.length() > 0) {
            try {
                Dimension position = VWStringUtils.stringToDimension((String)vwUserInfo.getFieldValue(positionKey));
                if (position != null) {
                    if (position.width <= 0) {
                        position.width = 20;
                    }
                    if (position.height <= 0) {
                        position.height = 20;
                    }
                    this.setLocation(position.width, position.height);
                }
            }
            catch (Exception ex) {
                bSuccessful = false;
            }
        }
        if (bSuccessful) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension appSize = this.getSize();
            Point location = this.getLocation();
            if (appSize.width > screenSize.width - 20) {
                appSize.width = screenSize.width - 20;
            }
            if (appSize.height > screenSize.height - 20) {
                appSize.height = screenSize.height - 20;
            }
            this.setSize(appSize);
            if (location.x + appSize.width > screenSize.width) {
                location.x = screenSize.width - (appSize.width + 20);
            }
            if (location.y + appSize.height > screenSize.height) {
                location.y = screenSize.height - (appSize.height + 20);
            }
            this.setLocation(location);
        }
        return bSuccessful;
    }

    protected void updateWindowPosition(int nAppWidth, int nAppHeight, int nPosition) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point location = this.getLocation();
        if (screenSize.width > nAppWidth) {
            switch (nPosition) {
                case 0: {
                    location.x = (screenSize.width - nAppWidth) / 2;
                    break;
                }
                case 1: 
                case 3: {
                    location.x = 20;
                    break;
                }
                case 2: 
                case 4: {
                    location.x = screenSize.width - nAppWidth - 20;
                }
            }
        } else {
            nAppWidth = screenSize.width - 20;
            location.x = 20;
        }
        if (screenSize.height > nAppHeight) {
            switch (nPosition) {
                case 0: {
                    location.y = (screenSize.height - nAppHeight) / 2;
                    break;
                }
                case 1: 
                case 2: {
                    location.y = 20;
                    break;
                }
                case 3: 
                case 4: {
                    location.y = screenSize.height - nAppHeight - 60;
                }
            }
        } else {
            nAppHeight = screenSize.height - 20;
            location.y = 20;
        }
        this.setSize(nAppWidth, nAppHeight);
        this.setLocation(location);
    }
}

